/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.util.PiglinNameGenerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;

public class NamesLoader {
    public static void load() throws IOException {
        if (!VillagerNames.CONFIG.villagerGeneralConfig.hasRead) {
            VillagerNames.CONFIG.villagerNamesConfig.villagerNames = NamesLoader.loadJson("villagerNames.json");
            VillagerNames.CONFIG.golemNamesConfig.golemNames = NamesLoader.loadJson("golemNames.json");
            VillagerNames.CONFIG.sureNamesConfig.sureNames = NamesLoader.loadJson("surnameNames.json");
            VillagerNames.CONFIG.piglinNamesConfig.piglinNames = PiglinNameGenerator.getPiglinNameList();
            VillagerNames.CONFIG.piglinSurnamesConfig.piglinSurnames = PiglinNameGenerator.getPiglinSurnamesList();
            VillagerNames.CONFIG.villagerGeneralConfig.hasRead = true;
            VillagerNames.CONFIG_MANAGER.save();
        }
        if (VillagerNames.CONFIG.sureNamesConfig.sureNames.isEmpty()) {
            VillagerNames.CONFIG.sureNamesConfig.sureNames = NamesLoader.loadJson("surnameNames.json");
        }
        if (VillagerNames.CONFIG.piglinSurnamesConfig.piglinSurnames.isEmpty()) {
            VillagerNames.CONFIG.piglinSurnamesConfig.piglinSurnames = PiglinNameGenerator.getPiglinSurnamesList();
        }
        if (VillagerNames.CONFIG.piglinNamesConfig.piglinNames.isEmpty()) {
            VillagerNames.CONFIG.piglinNamesConfig.piglinNames = PiglinNameGenerator.getPiglinNameList();
        }
    }

    private static List<String> loadJson(String string) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        String result = IOUtils.toString((InputStream)NamesLoader.class.getResourceAsStream("/assets/villagernames/names/" + string), (Charset)StandardCharsets.UTF_8);
        JsonObject object = JsonParser.parseString((String)result).getAsJsonObject();
        JsonArray value = (JsonArray)object.get(string.substring(0, string.indexOf(".")));
        for (JsonElement jsonElement : value) {
            strings.add(jsonElement.getAsString());
        }
        return strings;
    }

    private static void jsonifyTxtFile(String file) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(NamesLoader.class.getResourceAsStream("/assets/villagernames/names/" + file)));
        reader.lines().forEach(strings::add);
        file = file.substring(0, file.indexOf("."));
        Path configPath = Paths.get(FabricLoader.getInstance().getConfigDir() + "/" + file + ".json", new String[0]);
        System.out.println(configPath);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
        JsonArray array = new JsonArray();
        strings.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        JsonObject object = new JsonObject();
        object.add("villagerNames", (JsonElement)array);
        gson.toJson((JsonElement)object, (Appendable)writer);
        writer.close();
    }
}

